<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ListView;
use yii\widgets\Pjax;
use kartik\widgets\ActiveForm;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Competencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Carga;

 
$this->title = 'Nivelaciones';
$this->params['breadcrumbs'][] = ['label' => 'Panel del Docente', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Guardar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-check"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];


$this->registerCss("
.table > thead > tr > td.salmon, 
.table > tbody > tr > td.salmon, 
.table > tfoot > tr > td.salmon, 
.table > thead > tr > th.salmon, 
.table > tbody > tr > th.salmon, 
.table > tfoot > tr > th.salmon, 
.table > thead > tr.salmon > td, 
.table > tbody > tr.salmon > td, 
.table > tfoot > tr.salmon > td, 
.table > thead > tr.salmon > th, 
.table > tbody > tr.salmon > th, 
.table > tfoot > tr.salmon > th {
    background-color: #D291BC;
}

.table-hover > tbody > tr > td.salmon:hover, 
.table-hover > tbody > tr > th.salmon:hover, 
.table-hover > tbody > tr.salmon:hover > td, 
.table-hover > tbody > tr:hover > .salmon, 
.table-hover > tbody > tr.salmon:hover > th 
{
    background-color: #C789B2;
}
.btn-salmon{
    color: #fff;
    background-color: #8D6B82;
    border-color: #87667C;
}



.table > thead > tr > td.purple, 
.table > tbody > tr > td.purple, 
.table > tfoot > tr > td.purple, 
.table > thead > tr > th.purple, 
.table > tbody > tr > th.purple, 
.table > tfoot > tr > th.purple, 
.table > thead > tr.purple > td, 
.table > tbody > tr.purple > td, 
.table > tfoot > tr.purple > td, 
.table > thead > tr.purple > th, 
.table > tbody > tr.purple > th, 
.table > tfoot > tr.purple > th {
    background-color: #E8C2ED;
}

.table-hover > tbody > tr > td.purple:hover, 
.table-hover > tbody > tr > th.purple:hover, 
.table-hover > tbody > tr.purple:hover > td, 
.table-hover > tbody > tr:hover > .purple, 
.table-hover > tbody > tr.purple:hover > th 
{
    background-color: #E0BBE4;
}
.btn-purple{
    color: #fff;
    background-color: #92278F;
    border-color: #81227E;
}

");

?>

<script type="text/javascript">         

<?php if ($tipo_calificacion != 1){ ?>


    function promediar(id,tipo) 
    { 
        var i;
        var promedio;
        var suma_saber = 0;
        var suma_ser = 0;
        var suma_psi = 0;
        var promedio_saber = 0;
        var promedio_ser = 0;
        var promedio_psi = 0;

        for (i = 1; i <= <?= $num_calificaciones_saber ?>; i++) {
            suma_saber = suma_saber + Number(document.getElementById("calificacion-" + id + "-saber-" + i).value);
            console.log('Saber id: ' + id + ' i: ' + i); 
        }

        promedio_saber = Number(((suma_saber / <?= $num_calificaciones_saber ?> ) * <?= $por_calificaciones_saber ?>) / 100); 


<?php if ($num_calificaciones_ser != 0){ ?>

        for (i = 1; i <= <?= $num_calificaciones_ser ?>; i++) {
            suma_ser = suma_ser + Number(document.getElementById("calificacion-" + id + "-ser-" + i).value);
            console.log('Ser id: ' + id + ' i: ' + i); 
        }

        promedio_ser = Number(((suma_ser / <?= $num_calificaciones_ser ?> ) * <?= $por_calificaciones_ser ?>) / 100); 

<?php } ?>

<?php if ($psi == 1){ ?>
        
        for (i = 1; i <= <?= $num_calificaciones_psi ?>; i++) {
            suma_psi = suma_psi + Number(document.getElementById("calificacion-" + id + "-psi-" + i).value);
            console.log('Psi id: ' + id + ' i: ' + i); 
        }

        promedio_psi = Number(((suma_psi / <?= $num_calificaciones_psi ?> ) * <?= $por_calificaciones_psi ?>) / 100); 

<?php } ?>
        
        promedio = promedio_saber + promedio_ser + promedio_psi; 

        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + promedio +'&tipo_calificacion=' + tipo,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+id).text(promedio.toFixed(1));



        if (e.keyCode == 13) {
           /* FOCUS ELEMENT */
           var inputs = $(this).parents('form').eq(0).find(':input');
           var idx = inputs.index(this);

           if (idx == inputs.length - 1) {
               inputs[0].select()
           } else {
               inputs[idx + 1].focus(); //  handles submit buttons
               inputs[idx + 1].select();
           }
           return false;
       }
        //console.log(promedio.toFixed(2)); 
    }

<?php } ?>

    function aplicaratodos(id,tipo,total,tipo_calificacion,calificacionxcompetencia)
      {  

         //declaras una variable y un array
         var i,ArrayText = new Array();
         // obtienes el valor del elemento vr1 
         text1 = document.getElementById('op-nivelacion').value;


         
         // actualizas cada text
         for(i=0; i<total; i++)
         {
            //alert('calificacion-'+ i +'-'+ tipo +'-'+id);

            if(calificacionxcompetencia == 1)
            {
                ArrayText[i] = document.getElementById('calificacion-'+ i +'-nivelacion');
            }
            else
            {
                ArrayText[i] = document.getElementById('calificacion-'+ i +'-nivelacion-'+id);    
            }

            ArrayText[i].value=text1.toUpperCase();
            
            <?php if ($tipo_calificacion != 1){ ?>
                promediar(i,tipo_calificacion);
            <?php }else{ ?> 
                desempeno(i,ArrayText[i]);   
            <?php } ?> 
         }
      }

    function mayusculas(id,e) 
    {
        e.value = e.value.toUpperCase();
    }

    function desempeno(id,e) 
    {
        //i = document.getElementById(e).value
        //nota = i.toUpperCase();     
        //document.getElementById(e).value = nota;

        e.value = e.value.toUpperCase();

        //alert(e.value);

        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + e.value +'&tipo_calificacion=' + <?= $tipo_calificacion ?>,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+id).text(e.value);


        <?php if ($tipo_calificacion != 1){ ?>
            $('#'+id).text(promedio.toFixed(1));
            //console.log(promedio.toFixed(2)); 
        <?php } ?>   
        
    }


    function validar(e) 
    {
        i = document.getElementById(e).value
        nota = i.toUpperCase()
                .toString().replace(".", ",")
                .toString().replace("-", ",")
                .toString().replace("_", ",")
                .toString().replace("+", ",")
                .toString().replace(";", ",")
                .toString().replace(":", ",")
                .toString().replace("ç", ",")
                .toString().replace("}", ",");     

        document.getElementById(e).value = nota;

    } 

</script>
    
    

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="demo-btn-group">
            <div class="callout callout-success">
                <div class="row"> 
                    <div class="col-sm-12">
                        <h4>
                            <?
                                $docente = Carga::find()->where(['asignatura' => Yii::$app->request->get('asignatura'), 'grupo' => Yii::$app->request->get('grupo')])->one(); 

                                echo (isset($docente)) ? $docente->docentes->nombre : 'Sin Docente Asignado';
                            ?>
                        </h4>
                    </div>
                </div>
                <div class="row"> 
                    <div class="col-sm-4">
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-chalkboard-teacher fa-lg text-warning"></i>
                            <? 
                                $asignatura = Asignatura::findOne(Yii::$app->request->get('asignatura'));
                                echo $asignatura->asignatura.' <small class="text-success">'.$asignatura->especialidades->especialidad.'</small>';
                            ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-users fa-lg text-primary"></i>
                            <?= "Grupo ".$docente->grupos->grupo; ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-clock fa-lg text-danger"></i>
                            <?= "Periodo ".$periodo->actual->id; ?>
                        </h5>
                    </div>
                    <div class="col-sm-4">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-pencil fa-lg text-success"></i>
                            <?= ($grupo->grados->calificacionxcompetencia == 1) ? '<span class="label label-primary">Calificación por Asignatura</span' : '<span class="label label-success">Calificación por Competencia</span>'; ?>    
                            &nbsp; 
                            <?= '<span class="label label-info">'.$grupo->grados->tipoCalificaciones->tipo.'</span>'; ?>
                        </h5>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</div>
<br>
<?php 
    
    if ($calificacionxcompetencia == '2')
    {    
        
        if($num_competencias == 0 or $num_competencias == NULL or $num_competencias == '')
        {
?>

            <div class="row"> 
                <div class="col-sm-12"> 

                    <div class="alert alert-danger alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?  
                            echo '<b>No hay competencias cargadas en la asignatura</b>, debes cargar las competencias primero para poder realizar el cargue de las calificaciones. ';
                            echo Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Competencias', ['competencia/create', 'grado' => $grupo->grados->id, 'asignatura' => Yii::$app->request->get('asignatura')],['class' => 'btn btn-xs btn-primary']);
                        ?>
                    </div>
                </div>
            </div>
<?php
        }
        else
        {    
            
            $x=1; 
       
?>        
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="alert alert-info alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?  
                            echo '<b>Competencias</b><br><ul>';

                            foreach ($competencias as $competencia) {
                                echo '<li><i class="fas fa-caret-right"></i>&nbsp;&nbsp;'.$competencia->competencia.'</li>';
                            }

                        ?>
                        </ul>
                    </div>        
                </div>
            </div>

<?
            
        }    
    }
?>    

    <? 
        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                        ]
        ]);
    ?>

    <div class="row"> 
        <div class="col-sm-12"> 

            <div class="alert alert-info alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?  
                    echo '<h5 style="display:inline-block;">Tipo de Calificación <span class="label label-info">'.$grupo->grados->tipoCalificaciones->tipo.'</span></h5>';

                    $desempenos = Desempeno::find()->where(['tipo_calificacion' => $grupo->grados->tipo_calificacion])->all();
                    foreach ($desempenos as $desempeno) {
                        $rango = ($desempeno->limite_inferior != '') ? ' ('.$desempeno->limite_inferior : '';
                        $rango .= ($desempeno->limite_superior != '') ? ' a '.$desempeno->limite_superior.')' : '';    
                        echo '<div style="display:inline-block;"><span class="label" data-toggle="tooltip" title="'.$desempeno->desempeno.''.$rango.'" style="width:50px; background-color:'.$desempeno->color.'; color:#fff; margin:0 2px 0 10px;">'.$desempeno->nota.'</span> <b>'.$desempeno->desempeno.'</b><small> '.$rango.'</small></div>';
                    }
                ?>
            </div>
        </div>
    </div>

    <div class="row"> 
        <div class="col-sm-12">     
            <?= $form->errorSummary($calificaciones); ?>
        </div>
    </div>

<?php if($dataProvider->getTotalCount()!= 0) { ?>

    <div class="row"> 
        <div class="col-sm-12">     
            <div class="table-responsive">    
              <table class="table table-hover table-striped">
                <thead>

                    
                  <tr>
                    <th rowspan="2">#</th>
                    <th rowspan="2" style="min-width:300px">Estudiante</th>
                    <?
                        if($periodo->actual->id !='1')
                        {    
                            echo '<th colspan="'.($periodo->actual->id - 1).'">Histórico</th>';
                        }
                    ?>        
                    
                    <?
                    $x = 1; 
                        foreach ($competencias as $competencia) {
                        
                            echo '<th colspan="1">';
                                
                            echo Html::tag('span','<i class="fas fa-info-circle"></i> Nivelación', ['class' => 'btn btn-block btn-danger', 'data-toggle' => 'tooltip', 'title' => $competencia->competencia]);

                            echo '</th>';
                            $x++;
                        }
                    ?>

                    <th rowspan="2" style="min-width:80px; vertical-align: middle; text-align: center;">
                        <?= Html::tag('span', '<i class="fas fa-info-circle"></i>', ['title' => 'Definitiva del Periodo', 'data-toggle' => 'tooltip', 'class' => 'text-info']);  ?>
                    </th>

                  </tr>
                  <tr>
                    <?
                        for($x=1;$x<$periodo->actual->id;$x++)
                        {   
                            echo '<th width="90px">P'.$x.'</th>';  
                        }
                    ?>       
                    <th>
                        <?= $this->render('_seleccionmultiplenivelacion', ['model' => $seleccionmultiple, 'i' => '1', 'num_calificaciones' => $num_calificaciones_ser, 'tipo' => 'ser', 'total_estudiantes' => $dataProvider->getTotalCount(),'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]); ?>
                    </th>
                    
                  </tr>
                </thead>
                <tbody>

<?php } ?>

            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'options' => [
                    'tag' => 'div',
                    'class' => 'list-wrapper',
                    'id' => 'list-wrapper',
                ],
                'viewParams' => ['calificaciones' => $calificaciones, 
                                    'registros' => $registros,
                                    'form' => $form, 
                                    'psi' => $psi,
                                    'periodo' => $periodo->actual->id, 
                                    'competencias' => $competencias,
                                    'tipo_calificacion' => $tipo_calificacion,
                                    'entrada' => $entrada,
                                    'fallas' => $fallas,
                                    'frd' => $frd,
                                    'calificacionxcompetencia' => $calificacionxcompetencia,
                                    'num_competencias' => $num_competencias,
                                    'num_calificaciones_saber' => $num_calificaciones_saber,
                                    'num_calificaciones_ser' => $num_calificaciones_ser,   
                                    'por_calificaciones_saber' => $por_calificaciones_saber,
                                    'por_calificaciones_ser' => $por_calificaciones_ser,
                                    'num_calificaciones_psi' => $num_calificaciones_psi,
                                    'por_calificaciones_psi' => $por_calificaciones_psi,
                                ],
                'itemView' => '_list_nivelaciones',
                'layout' => "{pager}\n{items}\n{summary}",
                'summary'=>'', 
            ]);
                
            ?>
           
<?php if($dataProvider->getTotalCount()!= 0) { ?> 
          
                </tbody>
            </table> 
    </div>

<?php } ?>

<? ActiveForm::end(); ?>



